// tabs.js

	
//qqbrowser.js.widgets={};

qqbrowser.js.widgets._tab = qqbrowser.js.base
		.Class(
				qqbrowser.js.widgets.widget,
				{
					className : "qqbrowser.js.widgets._tab",

					_tabs : null,
					_favIconImg : null,
					_titleDiv : null,
					_closeTabButton : null,
					_tabHolder : null,
			
					_closeButtonClickListener : null,
					_removeTabListener : null,
					
					_pageId : null,
					_isInnerPage : null,
					_loadtimer : -1,
					_cnt : 0,
					
					initialize : function(id, tabs) {
						var _this = this;

						
						this._element = document.createElement("div");
						this._element.tab = this;
						this._tabs = tabs;

						this.initTab(id);

						this._element.onmouseover = function(event) {
							_this.addClass("hover");
						};

						this._element.onmouseout = function(event){
							if (event.target === _this._favIconImg) {
								event.stopPropagation();
							}
							
							_this.removeClass("hover");
							return false;
							//event.stopPropagation();
						};

						this._element.onclick = function() {

						};

						this._element.onmousedown = function(event) {
							// _this.setActive(true);

							if (event.button === 0) { // Ҽmousedown¼ͻ
								if (null !== _this._tabs._tabClickListener) {
									_this._tabs._tabClickListener.apply(this, [
											event, _this.id ]);
								}
							}
                            if(event.button === 1){
                                if(null !== _this._tabs._tabCloseListener){
            						var freezeFlag = false;

        							if(_this._element === _this._tabs._tabset.lastChild) {
        								freezeFlag = true;
        							} else {
        								_this._tabs._freezeLayout(true);
        							}

        							if (null !== _this._closeButtonClickListener) {
        								_this._closeButtonClickListener.apply(this, [
        										event, _this ]);
        							}
        							if (freezeFlag){
//        								_this._tabs._placeHolderElement.style.webkitBoxFlex = 0;
        								_this._tabs._freezeLayout(false);

        								_this._tabs.adjustTabsLayout();
        							}

        							event.stopPropagation();
                                }
                            }


						}; 

						this._element.ondblclick = function(event) {
							// ö־
							var freezeFlag = false;

							if(_this._element === _this._tabs._tabset.lastChild) {
								freezeFlag = true;
							} else {
								_this._tabs._freezeLayout(true);
							}

							if (null !== _this._closeButtonClickListener) {
								_this._closeButtonClickListener.apply(this, [
										event, _this ]);
							}
							if (freezeFlag){
//								_this._tabs._placeHolderElement.style.webkitBoxFlex = 0;
								_this._tabs._freezeLayout(false);

								_this._tabs.adjustTabsLayout();
							}

							event.stopPropagation();
						};

						this._element.addEventListener("contextmenu", function(
								event) {
							// _this.setActive(true);

							if (null !== _this._tabs._tabContextMenuListener) {
								_this._tabs._tabContextMenuListener.apply(this,
										[ event, _this.id ]);
							}
						}, false);
						

						qqbrowser.js.widgets.widget.prototype.initialize.apply(
								this, [ id ]);
					},

					initTab : function(id) {
						var _this = this;
						
						this._tabHolder = document.createElement("div");
						this._tabHolder.setAttribute("id", "tabHolder"); 

						this.addClass("qqbrowser-widgets-tabs-tab");
						this._favIconImg = document.createElement("img");
						this._favIconImg.setAttribute("class",
								"qqbrowser-widgets-tabs-tab-favicon");
						
						
						// TabIconʱֻȡԴ쳣ôΪĬIcon
						this._favIconImg.addEventListener("error", function(event) {
							_this.setFavIcon();
						}, false);
						
						// 
						if (!this._isInnerPage) {
//							this.setFavIcon("qqbrowser://skin/images/tab/default_favicon.png");
						} 

						this._tabHolder.appendChild(this._favIconImg);

						this._titleDiv = document.createElement("div");
						this._titleDiv.setAttribute("class",
								"qqbrowser-widgets-tabs-tab-title");
						this._tabHolder.appendChild(this._titleDiv);
						
						var hFlex = document.createElement("div");
						hFlex.setAttribute("class", "h-flex");
						this._tabHolder.appendChild(hFlex);
						
						

						this._closeTabButton = new qqbrowser.js.widgets.button(
								"closeTabButton" + id);
						this._closeTabButton
								.setClass("qqbrowser-widgets-tabs-tab-close");
						this._closeTabButton.insert(this._tabHolder);
						
						// ֹmousedown¼ðݱϲԪزԼtab
						this._closeTabButton._element.addEventListener("mousedown", function(event) {
							event.stopPropagation();
							return false;
						}, false);
						
						this._closeTabButton.onclick(function(event) {
							// ö־
							var freezeFlag = false;

							if(_this._element === _this._tabs._tabset.lastChild) {
								freezeFlag = true;
							} else {
								_this._tabs._freezeLayout(true);
							}

							if (null !== _this._closeButtonClickListener) {
								_this._closeButtonClickListener.apply(this, [
										event, _this ]);
							}
							if (freezeFlag){
//								_this._tabs._placeHolderElement.style.webkitBoxFlex = 0;
								_this._tabs._freezeLayout(false);

								_this._tabs.adjustTabsLayout();
							}

							// ֹ¼ðݱϲԪز
							event.stopPropagation();
							
						});
						
						this._element.appendChild(this._tabHolder);
					},

					setActiveClass : function(isActive) {
						if (isActive) {
							
							this.removeClass("hover");
							this.addClass("active");
							this.showCloseButton(true);
						} else {
							this.removeClass("active");
							if (!this._tabs._showCloseButton) {
								this.showCloseButton(false);
							}
						}
					},

					setActive : function() {
						if (this._tabs.activeTab) {
							this._tabs.activeTab.setActiveClass(false);
						}

						this.setActiveClass(true);
						this._tabs.activeTab = this;
                        this._tabs.adjustTabsLayout(true);

					},

					setWidth : function(newWidth) {
                        if(newWidth){
                            this._element.style.maxWidth = newWidth + "px";
                            $(this._element).width(newWidth + "px");
                             $(this._element).css("width",newWidth);
                            this._element.clientWidth = newWidth+"px";
                            /*this._element.style.width = newWidth + "px";*/

                        }
					},

					remove : function() {

						this._element.tab = null; // Ƴ
						this._element.parentElement.removeChild(this._element);
					},

					showFavIcon : function(visible) {
						if (!visible) {
							this._favIconImg.style.display = "none";
						} else {
							this._favIconImg.style.display = "inherit";
						}
					},

					showTitle : function(visible) {
						if (!visible) {
							this._titleDiv.style.display = "none";
						} else {
							this._titleDiv.style.display = "block";
						}
					},

					showCloseButton : function(visible) {
						if (!visible) {
							this._closeTabButton._element.style.display = "none";
						} else {
							this._closeTabButton._element.style.display = "inherit";
						}
					},

					setFavIcon : function(newFavIcon) {
						this._favIconImg.setAttribute("class",
								"qqbrowser-widgets-tabs-tab-favicon");
						if (newFavIcon) {
                            if(newFavIcon.indexOf("qqbrowser://skin/images/innerIcons") !== -1 &&
                                qqbrowser.js.logic.skinStatus !== null &&
                                newFavIcon.indexOf(qqbrowser.js.logic.skinStatus) === -1){
                                newFavIcon = newFavIcon.indexOf("?")===-1?newFavIcon:newFavIcon.substring(0,newFavIcon.indexOf("?"));
                                this._favIconImg.setAttribute("src", newFavIcon+"?v="+
                                qqbrowser.js.logic.skinStatus);
                            } else{
                                this._favIconImg.setAttribute("src", newFavIcon);
                            }
						} else{
                            this._favIconImg.setAttribute("src", "qqbrowser://skin/images/tab/default_favicon.png");
                        }

						// setFavIconAsLoadingļʱ
						clearInterval(this._loadtimer);
						this._loadtimer = -1;
					},

					setFavIconAsLoading : function() {

						var  _this = this;
						if (this._loadtimer === -1) {
							clearInterval(this._loadtimer);
						}
						if ( this._loadtimer <= 0 ) { // ͬһtab󶨶ʱ
							this._loadtimer = setInterval(function() {
								var basepath = "qqbrowser://skin/images/tab/loading/";
								var cnt = _this._cnt;
								cnt%= 11;
								var imgpath = [(cnt + 1), ".png"].join("");
								_this._favIconImg.setAttribute("src", [basepath,imgpath].join(""));
								cnt++;
								_this._cnt = cnt;
							}, 100);
						}
					},

					setTitle : function(newTitle) {
						this._titleDiv.innerText = newTitle;
					},

					setInnerPage : function(isInnerPage) {
						this._isInnerPage = isInnerPage;
					},

					onCloseButtonClick : function(func) {
						this._closeButtonClickListener = func;
					},

					onRemoveTab : function(func) {
						this.__removeTabListener = func;
					}
				});

qqbrowser.js.widgets.tabs = qqbrowser.js.base
		.Class(
				qqbrowser.js.widgets.widget,
				{
					className : "qqbrowser.js.widgets.tabs",

					activeTab : null, // ǰtab

					_tabset : null,
					_tabClass : null,
					_addtabButton : null, // tabť
					_placeHolderElement : null,

					_defaultTabWidth : 195, // Ĭtab
					_currentTabWidth : null,
					_leastTabWidth : 0,
					_currentTabId : 0,
					_need4Layout : false,
					_showCloseButton : true,

					_maxTabCount : 100, // ֵ֧tab
					_addtabButtonClickListener : null,
					_tabCreateListener : null,
					_tabClickListener : null,
					_tabCloseListener : null,
					_tabDragStopListener : null,
					_tabContextMenuListener : null,

					initialize : function(id) {
						var _this = this;

						this._element = document.createElement("div");

						this._tabset = document.createElement("div");
						this._tabset.setAttribute("id",
								"qqbrowser-widgets-tabs-tabset");
						this._element.appendChild(this._tabset);//cristext
						this.setClass("qqbrowser-widgets-tabs");



						this._addtabButton = new qqbrowser.js.widgets.button(
								"qqbrowser-widgets-tabs-addtab");
						this._addtabButton.insert(this._tabset);
                       /* console.log("cristest:",this);
                        console.log("cristest:",this._tabset);*/
                        this._addtabButton.insert(this._element);
						this._addtabButton.onclick(function() {
							// _this.createTab();

							if (null !== _this._addtabButtonClickListener) {
								_this._addtabButtonClickListener.apply(this, [
										event, _this ]);
							}
							event.stopPropagation();
						});

						window.addEventListener("resize", function(event) {
							_this.adjustTabsLayout();
						});

						this._element.onmouseout = function(event) {
							/*browser.log("onmouseoutonmouseout");
                            //console.log("cris in on mouseout:",event.relatedTarget);*/
                            var target = _this._element;
                            var obj = event.relatedTarget;
                            //ͨѭԱжǲobjĸԪ
                            while(obj!=null &&typeof(obj.tagName) != "undefind"){
                                if(obj === target){
                                    return ;
                                }
                                obj=obj.parentNode;
                            }
                           
                            //
                            if(qqbrowser.layout.tabs && qqbrowser.layout.tabs.isDraging) {
//                            	 browser.log("onmouseout");
//                            	qqbrowser.layout.tabs.activeTab.mouseup();
//                            	qqbrowser.layout.tabs.isDraging = false;
                            }
							if (true === _this._need4Layout) {
								//browser.log(currentTarget.getAttribute("id"));
								_this._freezeLayout(false);

								_this.adjustTabsLayout();
								_this._need4Layout = false;
							}
						};

						qqbrowser.js.widgets.widget.prototype.initialize.apply(
								this, [ id ]);
					},

					_freezeLayout : function(isFrozen) {
						var tabWidth = this._tabset.childNodes[0].clientWidth;
						var tabCount = this._tabset.childNodes.length;


						if (!isFrozen) { // ⶳ
							for ( var i = 0; i < tabCount; ++i) {
								var tab = this._tabset.childNodes[i];
								tab.style.webkitBoxFlex = "1";
//								tab.style.width = "";
							}
                        }

					},

					adjustTabsLayout : function(isNotAdjust) {

						/*var viewManager = qqbrowser.js.logic.viewManager;
                        var tabbar = document.getElementById("main-tabbar");
                        var windowWidth = $(window).width();
                        var tabbarMargin = viewManager.getMargin(tabbar);
                        var tabInnerWidth =windowWidth
                                   - tabbarMargin.left
                                   -tabbarMargin.right;
						// ȡaddtabButtonťbordermargin
						var addtabButtonBorderWidth = viewManager
								.getBorderWidth(this._addtabButton._element);
						var addtabButtonMargin = viewManager
								.getMargin(this._addtabButton._element);

						// tabܳ
						var tabsWidth = tabInnerWidth
								- this._addtabButton._element.clientWidth
								- addtabButtonBorderWidth.left
								- addtabButtonBorderWidth.right
								- addtabButtonMargin.left
								- addtabButtonMargin.right;
						var tabCount = this.getTabsCount();


						// ȡһtabǰDOMԪأڼ
						var tabElement = this._tabset.firstChild;
						if (tabCount === 1 || !tabElement) {
							return;
						}

						// ȡÿtabborderԼmarginڼtabĿ
						var tabBorder = viewManager.getBorderWidth(tabElement);
                        var tabMargin = viewManager.getMargin(tabElement);
                        var border = tabBorder.left + tabBorder.right;
                        var margin = tabMargin.left + tabMargin.right;


						var tabMaxWidth = parseInt((tabsWidth - tabCount
								* (border + margin))
								/ tabCount, 10);

						// ڲʱλλ
						var restPx = parseInt((tabsWidth - tabCount
								* (border + margin))
								% tabCount, 10);

//						browser.log("tabMaxWidth:" + tabMaxWidth);

						var tabWidth = tabMaxWidth < this._defaultTabWidth ? tabMaxWidth
								: this._defaultTabWidth;

//
//						if (tabWidth === tabMaxWidth) {
//							this._placeHolderElement.style.webkitBoxFlex = 1;
//						} else {
//							this._placeHolderElement.style.webkitBoxFlex = 0;
//						}
////						browser.log("this._placeHolderElement.style.webkitBoxFlex:" + this._placeHolderElement.style.webkitBoxFlex);
//
						this._currentTabWidth = tabWidth;
//						console.info("tabWidth" + tabWidth);
                       // var tabsWidth= 0;
						for ( var i = 0; i < tabCount; i++) {
							var tab = this._tabset.children[i].tab;
//							// ֮
                            if(!isNotAdjust){
							    if (i < restPx) {
								    tab.setWidth(this._currentTabWidth + 1);
							    } else {
								    tab.setWidth(this._currentTabWidth);
							    }
                              //  tabsWidth += tab._element.offsetWidth;
                            }
                           // $("#qqbrowser-widgets-tabs-tabset").width = tabsWidth;
//
							// ǩԪʾ߼
							if (tabWidth <= 52 && tabWidth > 32) {
								tab.showTitle(false);
								tab.showFavIcon(true);
								tab.showCloseButton(true);
							} else if (tabWidth <= 32 && tabWidth > 25) {
								tab.showTitle(false);
//								tab.showFavIcon(false);
//								tab.showCloseButton(true);
                                if(tab === this.activeTab){
                                    tab.showFavIcon(false);
                                    tab.showCloseButton(true);
                                }else{
                                    tab.showFavIcon(true);
                                    tab.showCloseButton(false);
                                }
							} else if (tabWidth <= 25) {
								tab.showTitle(false);
								tab.showFavIcon(false);
//								tab.showCloseButton(true);
                                if(tab !== this.activeTab){
                                    tab.showCloseButton(false);
                                }else{
                                    tab.showCloseButton(true);
                                }
							} else {
								tab.showTitle(true);
								tab.showFavIcon(true);
								tab.showCloseButton(true);
							}
						}*/

					},
					getTabsCount : function() {
						return this._tabset.children.length;//ΪʲôҪ1
					},

					setAddtabButtonClass : function(newClass) {
						this._addtabButton.setClass(newClass);
					},

					setTabClass : function(newClass) {
						this._tabClass = newClass;
					},

					setDefaultTabWidth : function(newWidth) {
						this._defaultTabWidth = newWidth;
					},

					getFirstTab : function() {
						return this._tabset.children[0].tab;
					},

					createTab : function(index) {
						var _this = this;

						var tab = new qqbrowser.js.widgets._tab("tab"
								+ this._currentTabId++, this);
						tab.addClass(this._tabClass);

                      /*  tab._element.onmouseover = function() {
                            if(qqbrowser.js.logic.tipManager){
                                qqbrowser.js.logic.tipManager.showTabTip(tab, event);
                            }

                            event.stopPropagation();
			            };*/

			            var closeTab = tab._closeTabButton;

                        closeTab._element.onmouseover = function() {
                            //console.log('cris:',tab._element);
                            closeTab.addClass("hover");
                            if(qqbrowser.js.logic.tipManager){                        
				                qqbrowser.js.logic.tipManager.showCloseTabTip(closeTab._element);
                            }
				           /* return false;*/
                            event.stopPropagation();
			            };
						if (!index || index >= _this.getTabsCount()) {
							index = this._tabset.childNodes.length;
						}
						var parent = this._tabset;
						var before = this._tabset.childNodes[index];
						parent.insertBefore(tab._element, before);

						// browser.log("createTab + _defaultTabWidth:" +
						// this._defaultTabWidth);
//						tab.setWidth(this._defaultTabWidth);

						// if (isActive) {
						// this.activeTab = tab;
						// tab.setActive(true);
						// }

						tab.onCloseButtonClick(function(event, tab) {
							_this._need4Layout = true;

							if (null !== _this._tabCloseListener) {
								_this._tabCloseListener.apply(this, [ event,
										tab.id ]);
							}
						});

						if (null !== this._tabCreateListener) {
							this._tabCreateListener.apply(this,
									[ null, tab.id ]);
						}
						
						//qqbrowser.js.logic.viewManager.setTabAero(true);
						//if (qqbrowser.js.logic.isAero) {
						//	tab.addClass("aero");
						//} else {
						//	tab.hasClass("aero") && tab.removeClass("aero");
						//}
						this.adjustTabsLayout();
						
						return tab;
					},

					onAddtabButtonClick : function(func) {
						this._addtabButtonClickListener = func;
					},

					onTabCreate : function(func) {
						this._tabCreateListener = func;
					},

					onTabClick : function(func) {
						this._tabClickListener = func;
					},

					onTabClose : function(func) {
						this._tabCloseListener = func;
					},

					onTabDragStop : function(func) {
						this._tabDragStopListener = func;
					},

					onTabContextMenu : function(func) {
						this._tabContextMenuListener = func;
					}

				});
